from VisualInterface import *
from NumericInterface import *
from DataInterface import *

from Visuals import *
from Numerics import *
from DataOut import *


nSpinsX = 18
nSpinsY = 2

stripeSpacingX = 6
stripeSpacingY = 2



k = 2.0*pi*vector(1.0,0.0,0.0)          # as of now, commensurate needed for stationany state




zArray = [[1.0,-1.0],[-1.0,1.0],[1.0,-1.0],[-1.0,1.0],[1.0,-1.0],[-1.0,1.0]]
phaseArray = [[0.0,0.0],[0.0,0.0],[0.0,0.0],[0.0,0.0],[0.0,0.0],[0.0,0.0]]

##chi = abs((cos(k.x)+cos(k.y))/2.0)
##spinMagRatio = .5*(1.0+1.0/chi-((1.0/chi-1.0)*(1.0/chi+3.0))**(0.5))

phiScale = 0.06
phiRatio = 0.33

phiArray = [[1.0,phiRatio],[phiRatio,1.0],[1.0,phiRatio],[phiRatio,1.0],[1.0,phiRatio],[phiRatio,1.0]]
##phiArray = [[1.0,1.0],[1.0,1.0],[1.0,1.0]]




Ja = -1.0
Jbx = -1.0
Jby = -1.0
Jad = -1.0

trackSpins = [(0,0)]
dt = .005



visuals = Visuals(nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, k)
numerics = Numerics(nSpinsX, nSpinsY, k, zArray, phaseArray, phiArray, phiScale, phiRatio, Ja, Jbx, Jby, Jad, dt, visuals)
dataOut = DataOut(trackSpins, numerics)

visualTk = Tk()
numericTk = Tk()
dataTk = Tk()

visualInterface = VisualInterface(visualTk, visuals)
numericInterface = NumericInterface(numericTk, numerics)
dataInterface = DataInterface(dataTk, dataOut)


visualTk.mainloop()
numericTk.mainloop()
dataTk.mainloop()




##    def set_spin_mag_ratio(self, _k=(1/8.,1/8.,1/8.)):
##        self.chi = abs((cos(_k.x*self.dx)+cos(_k.y*self.dy))/2)
##        self.spin_mag_ratio = .5*(1+1/self.chi-((1/self.chi-1)*(1/self.chi+3))**(.5))
##
####        self.cos = cos(_k.x*self.dx)+cos(_k.y*self.dy)
####        self.top = 2.0 - (4.0 - self.cos**2.0)**.5
####        self.bottom = self.cos
####
####        if abs(self.top < self.bottom):
####            self.spin_mag_ratio = self.top/self.bottom
####        else:
####            self.spin_mag_ratio = self.bottom/self.top
##
##        if abs(self.spin_mag_ratio) > 1:
##            self.spin_mag_ratio = 1/self.spin_mag_ratio
####        print 'new spin up to down magnitude ratio', self.spin_mag_ratio
